/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.example;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.montoyo.mcef.api.API;
import net.montoyo.mcef.api.CefInitEvent;
import net.montoyo.mcef.api.IBrowser;
import net.montoyo.mcef.api.IDisplayHandler;
import net.montoyo.mcef.api.IJSQueryCallback;
import net.montoyo.mcef.api.IJSQueryHandler;
import net.montoyo.mcef.example.BrowserScreen;
import net.montoyo.mcef.example.ModScheme;
import net.montoyo.mcef.example.ScreenCfg;
import net.montoyo.mcef.utilities.CefUtil;
import net.montoyo.mcef.utilities.Log;

public class ExampleMod
implements IDisplayHandler,
IJSQueryHandler {
    public static ExampleMod INSTANCE;
    public ScreenCfg hudBrowser = null;
    public KeyMapping key = new KeyMapping("Open Browser", InputConstants.Type.KEYSYM, 299, "key.categories.misc");
    private Minecraft mc = Minecraft.m_91087_();
    private BrowserScreen backup = null;
    private API api;

    public API getAPI() {
        return this.api;
    }

    public void onCefInit(CefInitEvent event) {
        this.api = event.getApi();
        if (this.api == null) {
            return;
        }
        this.api.registerScheme("mod", ModScheme.class, true, false, false, true, true, false, false);
        if (event.ranInit()) {
            INSTANCE = this;
            if (this.api != null) {
                this.api.registerDisplayHandler(this);
                this.api.registerJSQueryHandler(this);
            }
            MinecraftForge.EVENT_BUS.register((Object)this);
            MinecraftForge.EVENT_BUS.addListener(this::onTickStart);
        }
    }

    public void setBackup(BrowserScreen bu) {
        this.backup = bu;
    }

    public boolean hasBackup() {
        return this.backup != null;
    }

    public void showScreen(String url) {
        if (!CefUtil.init) {
            return;
        }
        if (this.mc.f_91080_ instanceof BrowserScreen) {
            ((BrowserScreen)this.mc.f_91080_).loadURL(url);
        } else if (this.hasBackup()) {
            this.mc.m_91152_((Screen)this.backup);
            this.backup.loadURL(url);
            this.backup = null;
        } else {
            this.mc.m_91152_((Screen)new BrowserScreen(url));
        }
    }

    public IBrowser getBrowser() {
        if (this.mc.f_91080_ instanceof BrowserScreen) {
            return ((BrowserScreen)this.mc.f_91080_).browser;
        }
        if (this.backup != null) {
            return this.backup.browser;
        }
        return null;
    }

    public void onTickStart(TickEvent.ClientTickEvent event) {
        if (this.key.m_90857_() && !(this.mc.f_91080_ instanceof BrowserScreen)) {
            this.mc.m_91152_((Screen)(this.hasBackup() ? this.backup : new BrowserScreen()));
            this.backup = null;
        }
    }

    @Override
    public void onAddressChange(IBrowser browser, String url) {
    }

    @Override
    public void onTitleChange(IBrowser browser, String title) {
    }

    @Override
    public void onTooltip(IBrowser browser, String text) {
    }

    @Override
    public void onStatusMessage(IBrowser browser, String value) {
    }

    @Override
    public boolean handleQuery(IBrowser b, long queryId, String query, boolean persistent, IJSQueryCallback cb) {
        if (b != null && query.equalsIgnoreCase("username")) {
            if (b.getURL().startsWith("mod://")) {
                this.mc.m_6367_(() -> {
                    try {
                        String name = this.mc.m_91094_().m_92546_();
                        cb.success(name);
                    }
                    catch (Throwable t) {
                        cb.failure(500, "Internal error.");
                        Log.warning("Could not get username from JavaScript:", new Object[0]);
                        t.printStackTrace();
                    }
                });
            } else {
                cb.failure(403, "Can't access username from external page");
            }
            return true;
        }
        return false;
    }

    @Override
    public void cancelQuery(IBrowser b, long queryId) {
    }

    public void onInit() {
        MinecraftForge.EVENT_BUS.addListener(this::onCefInit);
    }
}

